/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;
import lotus.domino.NotesThread;

/**
 * @author Thomas Ekert
 *
 */
public class DJStressRunner {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session

	private static final int STRESS_COUNT=100; //Anzahl der gleichzeitigen Tests
	private static final int DELAY = 100;      //Wartezeit in Millisekunden zwischen zwei Pfrfroutinen
	private static final int MAX_DELAY=50000;  //Maximallaufzeit in Millisekunden
	
	
	private static final int MAX_DELAY_COUNT = MAX_DELAY/DELAY;
	private static final boolean [] info = new boolean [STRESS_COUNT];
	private static DJStressTest [] st = new DJStressTest [STRESS_COUNT];
	private static NotesThread [] nt = new NotesThread [STRESS_COUNT];
	
	public static void main(String[] args) {
		try {
			//Alle Threads starten
			long L = System.currentTimeMillis();
			for (int i=0; i < STRESS_COUNT; i++) {
				st [i] = new DJStressTest ("Thread " + i,HOST, USER, PASSWORD);
				nt [i] = new NotesThread(st [i]);
				nt [i].start();
				info[i] = false;
			}
			//auf alle Ergebnisse warten
			int allDone=0;
			for (int dCount = 0; dCount < MAX_DELAY_COUNT && allDone!=STRESS_COUNT; dCount++) {
				int tmpDone = allDone;
				for (int i = 0; i < STRESS_COUNT; i++) {
					if (st [i].isDone() && !info [i]) {
						//System.out.println ("Thread " + i + " is done.");
						allDone++;
						info [i] = true;
					}
				}
				if (tmpDone != allDone) {
					System.out.println (allDone + " Threads done. (" + (System.currentTimeMillis() - L) + ")");
				}
				Thread.sleep(DELAY);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			//berfallige Threads stoppen
			for (int i = 0; i < STRESS_COUNT; i++) {
				if (!st [i].isDone()) {
					System.out.println ("Stopping Thread " + i);
					nt[i].stop();
				}
			}
		}
	}
	private DJStressRunner() {
		//hide from public
	}
}
